#include <stdio.h>
#include <string.h>
#include "sys.h"
#include "delay.h"   
#include "spi.h"
#include "usart.h"
#include "flash.h" 
#include "main.h"
#include "lcd.h"
#include "interface.h"

u8 is_Fread;
//u8 is_Erase_Chip_end=0; 
extern u8 is_picdata;	
extern LCD_CONFIG lcdconfig;	
u32 pic_start_addr=4096<<2;
PIC_INFO pic_info;	
u8 start_x=2;	//Xʼλ

void SPI_Flash_Init(void)	//flashʼ
{
	RCC->APB2ENR|=1<<2;       //PORTAʱʹ 	    
	GPIOA->CRL&=0XFFF000FF; 
	GPIOA->CRL|=0X00033300;//PA2.3.4  	    
	GPIOA->ODR|=0X7<<2;    //PA2.3.4
	SPIx_Init();
}  
//==============================================
//==============================================
//ȡSPI_FLASH״̬Ĵ
//BIT7  6   5   4   3   2   1   0
//SPR   RV  TB BP2 BP1 BP0 WEL BUSY
//SPR:Ĭ0,״̬Ĵλ,WPʹ
//TB,BP2,BP1,BP0:FLASHд
//WEL:дʹ
//BUSY:æλ(1,æ;0,)
//Ĭ:0x00
u8 SPI_Flash_ReadSR(void)   
{  
	u8 byte=0;   
	SPI_FLASH_CS=0;                            //ʹ   
	SPIx_ReadWriteByte(W25X_ReadStatusReg);    //Ͷȡ״̬Ĵ    
	byte=SPIx_ReadWriteByte(0Xff);             //ȡһֽ  
	SPI_FLASH_CS=1;                            //ȡƬѡ     
	return byte;   
} 
//дSPI_FLASH״̬Ĵ
//ֻSPR,TB,BP2,BP1,BP0(bit 7,5,4,3,2)д!!!
void SPI_FLASH_Write_SR(u8 sr)   
{   
	SPI_FLASH_CS=0;                            //ʹ   
	SPIx_ReadWriteByte(W25X_WriteStatusReg);   //дȡ״̬Ĵ    
	SPIx_ReadWriteByte(sr);               //дһֽ  
	SPI_FLASH_CS=1;                            //ȡƬѡ     	      
}   
//SPI_FLASHдʹ	
//WELλ   
void SPI_FLASH_Write_Enable(void)   
{
	SPI_FLASH_CS=0;                            //ʹ   
    SPIx_ReadWriteByte(W25X_WriteEnable);      //дʹ  
	SPI_FLASH_CS=1;                            //ȡƬѡ     	      
} 
//SPI_FLASHдֹ	
//WEL  
void SPI_FLASH_Write_Disable(void)   
{  
	SPI_FLASH_CS=0;                            //ʹ   
    SPIx_ReadWriteByte(W25X_WriteDisable);     //дָֹ    
	SPI_FLASH_CS=1;                            //ȡƬѡ     	      
} 			    
//ȡоƬID W25X16ID:0XEF14
u16 SPI_Flash_ReadID(void)
{
	u16 Temp = 0;	  
	SPI_FLASH_CS=0;				    
	SPIx_ReadWriteByte(0x90);//ͶȡID	    
	SPIx_ReadWriteByte(0x00); 	    
	SPIx_ReadWriteByte(0x00); 	    
	SPIx_ReadWriteByte(0x00); 	 			   
	Temp|=SPIx_ReadWriteByte(0xFF)<<8;  
	Temp|=SPIx_ReadWriteByte(0xFF);	 
	SPI_FLASH_CS=1;				    
	return Temp;
}   		    
//ȡSPI FLASH  
//ַָʼȡָȵ
//pBuffer:ݴ洢
//ReadAddr:ʼȡĵַ(24bit)
//NumByteToRead:Ҫȡֽ(65535)
void SPI_Flash_Read(u8* pBuffer,u32 ReadAddr,u16 NumByteToRead)   
{ 
 	u16 i;    												    
	SPI_FLASH_CS=0;                            //ʹ   
    SPIx_ReadWriteByte(W25X_ReadData);         //Ͷȡ   
    SPIx_ReadWriteByte((u8)((ReadAddr)>>16));  //24bitַ    
    SPIx_ReadWriteByte((u8)((ReadAddr)>>8));   
    SPIx_ReadWriteByte((u8)ReadAddr);   
    for(i=0;i<NumByteToRead;i++)
		{ 
        pBuffer[i]=SPIx_ReadWriteByte(0XFF);   //ѭ  
    }
	SPI_FLASH_CS=1;                            //ȡƬѡ     	      
}  
//SPIһҳ(0~65535)д256ֽڵ
//ַָʼд256ֽڵ
//pBuffer:ݴ洢
//WriteAddr:ʼдĵַ(24bit)
//NumByteToWrite:Ҫдֽ(256),Ӧóҳʣֽ!!!	 
void SPI_Flash_Write_Page(u8* pBuffer,u32 WriteAddr,u16 NumByteToWrite)
{
 	u16 i;  
    SPI_FLASH_Write_Enable();                  //SET WEL 
	SPI_FLASH_CS=0;                            //ʹ   
    SPIx_ReadWriteByte(W25X_PageProgram);      //дҳ   
    SPIx_ReadWriteByte((u8)((WriteAddr)>>16)); //24bitַ    
    SPIx_ReadWriteByte((u8)((WriteAddr)>>8));   
    SPIx_ReadWriteByte((u8)WriteAddr);   
    for(i=0;i<NumByteToWrite;i++)SPIx_ReadWriteByte(pBuffer[i]);//ѭд  
	SPI_FLASH_CS=1;                            //ȡƬѡ 
	SPI_Flash_Wait_Busy();					   //ȴд
} 
//޼дSPI FLASH 
//ȷдĵַΧڵȫΪ0XFF,ڷ0XFFдݽʧ!
//Զҳ 
//ַָʼдָȵ,ҪȷַԽ!
//pBuffer:ݴ洢
//WriteAddr:ʼдĵַ(24bit)
//NumByteToWrite:Ҫдֽ(65535)
//CHECK OK
void SPI_Flash_Write_NoCheck(u8* pBuffer,u32 WriteAddr,u16 NumByteToWrite)  
{
	u16 pageremain;	   
	pageremain=256-WriteAddr%256; //ҳʣֽ		 	    
	if(NumByteToWrite<=pageremain)pageremain=NumByteToWrite;//256ֽ
	while(1)
	{	   
		SPI_Flash_Write_Page(pBuffer,WriteAddr,pageremain);
		if(NumByteToWrite==pageremain)break;//д
	 	else //NumByteToWrite>pageremain
		{
			pBuffer+=pageremain;
			WriteAddr+=pageremain;	

			NumByteToWrite-=pageremain;			  //ȥѾд˵ֽ
			if(NumByteToWrite>256)pageremain=256; //һοд256ֽ
			else pageremain=NumByteToWrite; 	  //256ֽ
		}
	};	    
} 
//дSPI FLASH  
//ַָʼдָȵ
//ú!
//pBuffer:ݴ洢
//WriteAddr:ʼдĵַ(24bit)
//NumByteToWrite:Ҫдֽ(65535)  		   
u8 SPI_FLASH_BUF[4096];
void SPI_Flash_Write(u8* pBuffer,u32 WriteAddr,u16 NumByteToWrite)   
{ 
	u32 secpos;
	u16 secoff;
	u16 secremain;	   
 	u16 i;    

	secpos=WriteAddr/4096;//ַ 0~511 for w25x16
	secoff=WriteAddr%4096;//ڵƫ
	secremain=4096-secoff;//ʣռС   

	if(NumByteToWrite<=secremain)secremain=NumByteToWrite;//4096ֽ
	while(1) 
	{	
		SPI_Flash_Read(SPI_FLASH_BUF,secpos*4096,4096);//
		for(i=0;i<secremain;i++)//У
		{
			if(SPI_FLASH_BUF[secoff+i]!=0XFF)break;//Ҫ  	  
		}
		if(i<secremain)//Ҫ
		{
			SPI_Flash_Erase_Sector(secpos);//
			for(i=0;i<secremain;i++)	   //
			{
				SPI_FLASH_BUF[i+secoff]=pBuffer[i];	  
			}
			SPI_Flash_Write_NoCheck(SPI_FLASH_BUF,secpos*4096,4096);//д  

		}else SPI_Flash_Write_NoCheck(pBuffer,WriteAddr,secremain);//дѾ˵,ֱдʣ. 				   
		if(NumByteToWrite==secremain)break;//д
		else//дδ
		{
			secpos++;//ַ1
			secoff=0;//ƫλΪ0 	 

		   	pBuffer+=secremain;  //ָƫ
			WriteAddr+=secremain;//дַƫ	   
		   	NumByteToWrite-=secremain;				//ֽݼ
			if(NumByteToWrite>4096)secremain=4096;	//һд
			else secremain=NumByteToWrite;			//һд
		}	 
	};	 	 
}
//==========ͼƬ=================	
//ȴǷͼƬأFLASH
void waiteflash(void)
{
		while(1);
}
//оƬ
//Ƭʱ:
//W25X16:25s 
//W25X32:40s 
//W25X64:40s 
//ȴʱ䳬...
void SPI_Flash_Erase_Chip_ALL(void)   
{
    SPI_Flash_Wait_Busy();   
    SPI_FLASH_Write_Enable();                  //SET WEL 
    SPI_Flash_Wait_Busy();   
  	SPI_FLASH_CS=0;                            //ʹ   
   SPIx_ReadWriteByte(W25X_ChipErase);        //Ƭ  
		SPI_FLASH_CS=1;                            //ȡƬѡ     	      
		SPI_Flash_Wait_Busy();   				   //ȴоƬ
}   
//һ
//Dst_Addr:ַ 0~511 for w25x16
//һɽʱ:150ms
void SPI_Flash_Erase_Sector(u32 Dst_Addr)   
{   
//	Dst_Addr*=4096;
		Dst_Addr=Dst_Addr<<12;
    SPI_FLASH_Write_Enable();                  //SET WEL 	 
    SPI_Flash_Wait_Busy();   
  	SPI_FLASH_CS=0;                            //ʹ   
    SPIx_ReadWriteByte(W25X_SectorErase);      //ָ 
    SPIx_ReadWriteByte((u8)((Dst_Addr)>>16));  //24bitַ    
    SPIx_ReadWriteByte((u8)((Dst_Addr)>>8));   
    SPIx_ReadWriteByte((u8)Dst_Addr);  
	SPI_FLASH_CS=1;                            //ȡƬѡ     	      
    SPI_Flash_Wait_Busy();   				   //ȴ
}  
//ȴ
void SPI_Flash_Wait_Busy(void)   
{ 
	while ((SPI_Flash_ReadSR()&0x01)==0x01);   // ȴBUSYλ
}  
//ģʽ
void SPI_Flash_PowerDown(void)   
{ 
  	SPI_FLASH_CS=0;                            //ʹ   
    SPIx_ReadWriteByte(W25X_PowerDown);        //͵  
	SPI_FLASH_CS=1;                            //ȡƬѡ     	      
    delay_us(3);                               //ȴTPD  
}   
//
void SPI_Flash_WAKEUP(void)   
{  
  	SPI_FLASH_CS=0;                            //ʹ   
    SPIx_ReadWriteByte(W25X_ReleasePowerDown);   //  send W25X_PowerDown command 0xAB    
	SPI_FLASH_CS=1;                            //ȡƬѡ     	      
    delay_us(3);                               //ȴTRES1
}   
unsigned char pic_data[2];
void DisPic_Windows_From_FLASH(u32 ReadAddr,u32 NumByteToRead) 
{
	u32 j;
	LCD_CS_CLR;
	LCD_RS_SET;
	LCD_RD_SET;
	  SPI_Flash_Init();
		 for(j=0;j<NumByteToRead;j++)
	{

				SPI_FLASH_CS=0;                            //ʹ 
				SPIx_ReadWriteByte(W25X_ReadData);         //Ͷȡ 
			//	SPIx_ReadWriteByte(W25X_FastReadData); 	
				SPIx_ReadWriteByte((u8)((ReadAddr+(j))>>16));  //24bitַ    
				SPIx_ReadWriteByte((u8)((ReadAddr+(j))>>8));   
				SPIx_ReadWriteByte((u8)ReadAddr+(j));
		
				//pic_data[0]=SPIx_ReadWriteByte(0XFF);		//dummy
	
				pic_data[0]=SPIx_ReadWriteByte(0XFF);   //ѭ 
				pic_data[1]=SPIx_ReadWriteByte(0XFF);  
					SPI_FLASH_CS=0;   
		
					DATAOUT((pic_data[0]));
					LCD_WR_CLR;
					LCD_WR_SET;
		
					DATAOUT((pic_data[1]));
					LCD_WR_CLR;
					LCD_WR_SET;
	} 
		LCD_CS_SET;
		SPI_FLASH_CS=1;                                //ȡƬѡ 
}
void Disp_Flash_Pic_9b_Num(u8 num)	//H9BITȡͼƬ
{
	Read_FlashPic_9b(lcdconfig.pic_bytes*num + pic_start_addr,lcdconfig.pic_bytes); 
}
void Read_FlashPic_9b(u32 ReadAddr,u32 NumByteToRead)  	//H9BITȡͼƬ 
{ 
	u32 i;
	int data_r,data_g,data_b;
	int data_first_9bit,data_second_9bit;
	//	LCD_GPIOInit();
	//	LCD_WR_REG(0x36);
	//	LCD_WR_DATA(0x08);
	//  delay_ms(10);
	BlockWrite(lcdconfig.col_pre,lcdconfig.col+lcdconfig.col_pre-1,lcdconfig.row_pre,lcdconfig.row+lcdconfig.row_pre-1);
	 // SPI_Flash_Init();
		SPI_FLASH_CS=0;                              //ʹ 
		LCD_RD_SET;
		LCD_RS_SET;
		LCD_CS_CLR;
	
    SPIx_ReadWriteByte(W25X_ReadData);         //Ͷȡ   
    SPIx_ReadWriteByte((u8)((ReadAddr)>>16));  //24bitַ    
    SPIx_ReadWriteByte((u8)((ReadAddr)>>8));   
    SPIx_ReadWriteByte((u8)ReadAddr);  	
	
		for(i=0;i<NumByteToRead/3;i++)
		{ 
			data_r=(SPIx_ReadWriteByte(0XFF));
			data_g=(SPIx_ReadWriteByte(0XFF));
			data_b=(SPIx_ReadWriteByte(0XFF));
			
//			if(i<16)
//			printf("%2x %2x %2x ",data_r,data_g,data_b);
			
//			data_first_9bit=(((data_r&0xfc)<<1)|(((data_g&0xfc)>>5)&0x07))<<7;
//			data_second_9bit=((((data_g&0x00fc)<<4)&0x1c0)|(((data_b&0x00fc)>>2)&0x3f))<<7;		   
			
			data_first_9bit=((data_r&0xfc)<<8)|(((data_g&0xe0)<<2));
			data_second_9bit=((data_g&0x1c)<<11)|((data_b&0x00fc)<<5);		   
			

			DATAOUT(data_first_9bit);
			LCD_WR_CLR;
			LCD_WR_SET;
			
			DATAOUT(data_second_9bit);
			LCD_WR_CLR;
			LCD_WR_SET;
		} 
		SPI_FLASH_CS=1;                              //ȡƬѡ 
		LCD_CS_SET;
	}
void Disp_Flash_Pic_Num(u8 num)   	//ŴFlashȡͼƬһΪ0
{ 
		u32 i;
		u8 data_h,data_l; 
		u32 ReadAddr;
		u32 NumByteToRead;
	
		//ַΪlcdһͼƬֽxͼƬ
		ReadAddr=lcdconfig.pic_bytes*num + pic_start_addr;	//1
		NumByteToRead=lcdconfig.pic_bytes;
		BlockWrite(lcdconfig.col_pre,lcdconfig.col+lcdconfig.col_pre-1,lcdconfig.row_pre,lcdconfig.row+lcdconfig.row_pre-1);
		SPI_FLASH_CS=0;                              //ʹ 
		LCD_RD_SET;
		LCD_RS_SET;
		LCD_CS_CLR;
		is_Fread=1;
    SPIx_ReadWriteByte(W25X_ReadData);         //Ͷȡ   
    SPIx_ReadWriteByte((u8)((ReadAddr)>>16));  //24bitַ    
    SPIx_ReadWriteByte((u8)((ReadAddr)>>8));   
    SPIx_ReadWriteByte((u8)ReadAddr);  	
		for(i=0;i<(NumByteToRead>>1);i++)
		{ 
			data_h=	(SPIx_ReadWriteByte(0XFF));
			data_l=(SPIx_ReadWriteByte(0XFF));
			SendData(((u16)(data_h)<<8)|(data_l));
		} 
		SPI_FLASH_CS=1;                              //ȡƬѡ 
		LCD_CS_SET;
		is_Fread=0;
}
void Read_FlashPic(u32 ReadAddr,u32 NumByteToRead)   
{ 
		u32 i;
		u8 data_h,data_l; 
	//	LCD_GPIOInit();
	//	LCD_WR_REG(0x36);
	//	LCD_WR_DATA(0x08);
	//  delay_ms(10);
		BlockWrite(lcdconfig.col_pre,lcdconfig.col+lcdconfig.col_pre-1,lcdconfig.row_pre,lcdconfig.row+lcdconfig.row_pre-1);
	 // SPI_Flash_Init();
		SPI_FLASH_CS=0;                              //ʹ 
		LCD_RD_SET;
		LCD_RS_SET;
		LCD_CS_CLR;
		is_Fread=1;
    SPIx_ReadWriteByte(W25X_ReadData);         //Ͷȡ   
    SPIx_ReadWriteByte((u8)((ReadAddr)>>16));  //24bitַ    
    SPIx_ReadWriteByte((u8)((ReadAddr)>>8));   
    SPIx_ReadWriteByte((u8)ReadAddr);  	
	
		for(i=0;i<NumByteToRead>>1;i++)
		{ 
			data_h=	(SPIx_ReadWriteByte(0XFF));
			data_l=(SPIx_ReadWriteByte(0XFF));
			
		//	LCD_WR_DATA(((u16)(data_h)<<8)|(data_l));
//			LCD_CS_CLR;
			
			
//		DATAOUT(((u16)(data_h)<<8)|(data_l));
//			LCD_WR_CLR;
//			LCD_WR_SET;
			SendData(((u16)(data_h)<<8)|(data_l));
			
//		DATAOUT(data_l<<8);
//			LCD_WR_CLR;
//			LCD_WR_SET;
//		DATAOUT(data_h<<8);
//			LCD_WR_CLR;
//			LCD_WR_SET;

			
//		SendData(((u16)(data_h)<<8)|(data_l));
			
			
//			LCD_CS_SET;
	//		printf("%2x\r\n",(((u16)(data_h)<<8)|(data_l)));
//			DATAOUT((SPIx_ReadWriteByte(0XFF)));	
//			LCD_WR_CLR;
//			LCD_WR_SET;
//			DATAOUT((SPIx_ReadWriteByte(0XFF)));	
//			LCD_WR_CLR;
//			LCD_WR_SET;
		
		//	printf("%x %x ",pic_data[j],pic_data[j+1]);
		} 

		SPI_FLASH_CS=1;                              //ȡƬѡ 
		LCD_CS_SET;
}
 
void Read_FlashPic_H(u32 ReadAddr,u32 NumByteToRead)   
{ 
		u32 i;
		u8 data_h,data_l;
		LCD_GPIOInit();
//		LCD_WR_REG(0x36);
//		LCD_WR_DATA(0x08);//
		delay_ms(10);
		BlockWrite(lcdconfig.col_pre,lcdconfig.col+lcdconfig.col_pre-1,lcdconfig.row_pre,lcdconfig.row+lcdconfig.row_pre-1);
	  SPI_Flash_Init();
		SPI_FLASH_CS=0;                              //ʹ 
		LCD_RD_SET;
		LCD_RS_SET;
		LCD_CS_CLR;
    SPIx_ReadWriteByte(W25X_ReadData);         //Ͷȡ   
    SPIx_ReadWriteByte((u8)((ReadAddr)>>16));  //24bitַ    
    SPIx_ReadWriteByte((u8)((ReadAddr)>>8));   
    SPIx_ReadWriteByte((u8)ReadAddr);  	
	
		for(i=0;i<NumByteToRead/2;i++)
		{ 
			data_l=	(SPIx_ReadWriteByte(0XFF));
			data_h=(SPIx_ReadWriteByte(0XFF));	
			DATAOUT(((u16)(data_h)<<8)|(data_l));
			LCD_WR_CLR;
			LCD_WR_SET;
		} 
		SPI_FLASH_CS=0;      
		LCD_CS_SET;
	}

